#ifndef MCF_I2C_H_
#define MCF_I2C_H_

#define I2C_TX_MAX_PACKET_SIZE      8    //Maximum size of TX packet
#define I2C_TX_PACKET_SIZE          4    //Number of bytes to send to target device
#define I2C_RX_MAX_PACKET_SIZE      5    //Maximum size of RX packet
#define I2C_TX_MAX_PACKET_SIZECRC   9
#define I2C_RX_MAX_PACKET_SIZECRC   10
#define I2C_RX_PACKET_SIZE          5    //Number of bytes to received from target
#define I2C_TARGET_ADDRESS          0x01 //MCF8315DEVM I2C address

/*Length of Control word*/
#define CONTROL_WORD_LENGTH                 3
#define CONTROL_WORD_DIRECTION_OFFSET       7
#define CONTROL_WORD_CRC_OFFSET             6
#define CONTROL_WORD_DLEN_OFFSET            4
#define MEMORY_SECTION                      0x0
#define MEMORY_PAGE                         0x0

typedef enum{
    CRC_ENABLE = 0x1,
    CRC_DISABLE = 0x0,
} CRC_CONTROL_WORD;

typedef enum{
    DLEN_16 = (uint8_t) 0x00,
    DLEN_32 = (uint8_t) 0x01,
    DLEN_64 = (uint8_t) 0x10,
} DLEN_CONTROL_WORD;

extern uint32_t gTxLen, gTxCount;   //Counters for TX length and bytes sent
extern uint32_t gRxLen, gRxCount;   //Counters for RX length and bytes sent

/*Data received from Target*/
extern uint8_t gRxPacket[I2C_RX_MAX_PACKET_SIZE];
extern uint8_t gRxPacketCRC[I2C_RX_MAX_PACKET_SIZECRC];
extern uint8_t gTxPacket[I2C_TX_MAX_PACKET_SIZE];

/*Indicates status of I2C*/
enum I2cControllerStatus {
    I2C_STATUS_IDLE = 0,
    I2C_STATUS_TX_STARTED,
    I2C_STATUS_TX_INPROGRESS,
    I2C_STATUS_TX_COMPLETE,
    I2C_STATUS_RX_STARTED,
    I2C_STATUS_RX_INPROGRESS,
    I2C_STATUS_RX_COMPLETE,
    I2C_STATUS_ERROR,
} gI2cControllerStatus;

/*Function Declarations*/
extern bool I2C_write(unsigned long addr, unsigned long writedata);
extern bool I2C_read(unsigned long addr, unsigned long * result);

#endif /* MCF_I2C_H_ */
